/*
 * Decompiled with CFR 0.152.
 */
package com.cak.deepslate_processing;

import com.cak.deepslate_processing.DeepslateProcessingCommon;
import com.cak.deepslate_processing.PlatformTab;
import com.tterrag.registrate.util.entry.RegistryEntry;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceCollection;
import it.unimi.dsi.fastutil.objects.ReferenceLinkedOpenHashSet;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1087;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_918;

public class DPTabs {
    public static final TabInfo DEEPSLATE_PROCESSING = PlatformTab.register("deepslate_processing", () -> PlatformTab.buildTab(new RegistrateDisplayItemsGenerator(true, () -> DEEPSLATE_PROCESSING)));

    public static void register() {
    }

    private static class RegistrateDisplayItemsGenerator
    implements class_1761.class_7914 {
        private final boolean addItems;
        private final Supplier<TabInfo> tabFilter;

        @Environment(value=EnvType.CLIENT)
        private static Predicate<class_1792> makeClient3dItemPredicate() {
            return item -> {
                class_918 itemRenderer = class_310.method_1551().method_1480();
                class_1087 model = itemRenderer.method_4019(new class_1799((class_1935)item), null, null, 0);
                return model.method_4712();
            };
        }

        public RegistrateDisplayItemsGenerator(boolean addItems, Supplier<TabInfo> tabFilter) {
            this.addItems = addItems;
            this.tabFilter = tabFilter;
        }

        private static Function<class_1792, class_1799> makeStackFunc() {
            return class_1799::new;
        }

        public void accept(class_1761.class_8128 parameters, class_1761.class_7704 output) {
            Function<class_1792, class_1799> stackFunc = RegistrateDisplayItemsGenerator.makeStackFunc();
            LinkedList<class_1792> items = new LinkedList<class_1792>();
            if (this.addItems) {
                items.addAll(this.collectItems());
            }
            items.addAll(this.collectBlocks(item -> false));
            RegistrateDisplayItemsGenerator.outputAll(output, items, stackFunc);
        }

        private List<class_1792> collectBlocks(Predicate<class_1792> exclusionPredicate) {
            ReferenceArrayList items = new ReferenceArrayList();
            for (RegistryEntry entry : DeepslateProcessingCommon.REGISTRATE.getAll(class_7924.field_41254)) {
                class_1792 item;
                if (!PlatformTab.isInCreativeTab(entry, this.tabFilter.get()) || (item = ((class_2248)entry.get()).method_8389()) == class_1802.field_8162 || exclusionPredicate.test(item)) continue;
                items.add(item);
            }
            items = new ReferenceArrayList((ReferenceCollection)new ReferenceLinkedOpenHashSet((Collection)items));
            return items;
        }

        private List<class_1792> collectItems() {
            ReferenceArrayList items = new ReferenceArrayList();
            for (RegistryEntry entry : DeepslateProcessingCommon.REGISTRATE.getAll(class_7924.field_41197)) {
                class_1792 item;
                if (!PlatformTab.isInCreativeTab(entry, this.tabFilter.get()) || (item = (class_1792)entry.get()) instanceof class_1747) continue;
                items.add(item);
            }
            return items;
        }

        private static void applyOrderings(List<class_1792> items, List<ItemOrdering> orderings) {
            for (ItemOrdering ordering : orderings) {
                int anchorIndex = items.indexOf(ordering.anchor());
                if (anchorIndex == -1) continue;
                class_1792 item = ordering.item();
                int itemIndex = items.indexOf(item);
                if (itemIndex != -1) {
                    items.remove(itemIndex);
                    if (itemIndex < anchorIndex) {
                        --anchorIndex;
                    }
                }
                if (ordering.type() == ItemOrdering.Type.AFTER) {
                    items.add(anchorIndex + 1, item);
                    continue;
                }
                items.add(anchorIndex, item);
            }
        }

        private static void outputAll(class_1761.class_7704 output, List<class_1792> items, Function<class_1792, class_1799> stackFunc) {
            for (class_1792 item : items) {
                output.method_45420(stackFunc.apply(item));
            }
        }

        private record ItemOrdering(class_1792 item, class_1792 anchor, Type type) {
            public static ItemOrdering before(class_1792 item, class_1792 anchor) {
                return new ItemOrdering(item, anchor, Type.BEFORE);
            }

            public static ItemOrdering after(class_1792 item, class_1792 anchor) {
                return new ItemOrdering(item, anchor, Type.AFTER);
            }

            public static enum Type {
                BEFORE,
                AFTER;

            }
        }
    }

    public record TabInfo(class_5321<class_1761> key, Supplier<class_1761> tab) {
    }
}

